function pcalib_walkpc3d(Xm, P, b_model, pcind, stdevlimits, dstep, axis_h)
% function pcalib_walkpc(Xm, P, b_model, pcind, stdevlimits, dstep, axis_h)
%
% A simple script to walk along a specific principle component.
%
% Inputs:
%  Xm - the mean shape as a column vector of the form x = [x_1, y_1, x_2, y_2, ..., x_N, y_N]';
%  P - a matrix whose columns represent the principle components
%  pcind - an scalar which denotes the princple axes to move along
%  stdevlimits - number of standard deviations to move [-1 1];
%  axis_h - the handle to the axis to show the walk
%
% Dr. A. I. Hanna (2006)

if nargin<5
    axis_h = gca;
end
if nargin<4
    stdevlimits = [-1 1];
end
b = zeros(size(P,2),1);
ph = plot3(axis_h, Xm(1:3:end), Xm(2:3:end), Xm(3:3:end),'-ro');
axis(axis_h, 'image');
setAxisLimits(Xm, P, b_model, pcind, stdevlimits, axis_h);
init = 1;
for i=stdevlimits(1):dstep:stdevlimits(2)
    b(pcind) = i*sqrt(b_model(pcind));
    x = Xm + P*b;
    x = reshape(x, 3, length(x)/3);
    set(ph, 'XData', x(1,:), 'YData', x(2,:), 'ZData', x(3,:));
    drawnow
    pause(.1)
end
%%%
%
%%%
function setAxisLimits(Xm, P, b_model, pcind, stdevlimits, axish)
[cxlim1, cylim1] = getShapeLimits(Xm, P, b_model, pcind, stdevlimits(1));
[cxlim2, cylim2] = getShapeLimits(Xm, P, b_model, pcind, stdevlimits(2));
set(axish, 'Xlim', [min(cxlim1(1), cxlim2(1)), max(cxlim1(2), cxlim2(2))]*1.2);
set(axish, 'Ylim', [min(cylim1(1), cylim2(1)), max(cylim1(2), cylim2(2))]*1.2);
%%%
%
%%%
function [cxlim, cylim] = getShapeLimits(Xm, P, b_model, pcind, stdev)
b = zeros(size(P,2),1);
b(pcind) = stdev*sqrt(b_model(pcind));
x = Xm + P*b;
x = reshape(x, 2, length(x)/2);
cxlim = [min(x(1,:)), max(x(1,:))];
cylim = [min(x(2,:)), max(x(2,:))];
return;